unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ColorProgressBar, AppEvnts;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    ColorProgressBar1: TColorProgressBar;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    ApplicationEvents1: TApplicationEvents;
    procedure ApplicationEvents1Message(var Msg: tagMSG; var Handled: Boolean);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
const
  poziomNiski=33;
  poziomWysoki=66;
var
  stan :TSystemPowerStatus;
  bateriaObecna :Boolean;
begin
GetSystemPowerStatus(stan);

//stan AC
case stan.ACLineStatus of
  0 :Label2.Caption:='odczone';
  1 :Label2.Caption:='zaczone';
  255 :Label2.Caption:='stan nieznany';
end;

//stan baterii
Label4.Caption:='uywana';
if (stan.BatteryFlag and 256)=256 then Label4.Caption:='nieznany';
if (stan.BatteryFlag and 128)=128 then Label4.Caption:='brak';
if (stan.BatteryFlag and 8)=8 then Label4.Caption:='adowanie';

bateriaObecna:=not ((stan.BatteryFlag and 128)=128);
if bateriaObecna then
  begin
  if (stan.BatteryFlag and 1)=1 then Label4.Caption:=Label4.Caption+', wysoki';
  if (stan.BatteryFlag and 2)=2 then Label4.Caption:=Label4.Caption+', niski';
  if (stan.BatteryFlag and 4)=4 then Label4.Caption:=Label4.Caption+', krytyczny';
  end;

//poziom baterii
if stan.BatteryLifePercent=255 then
  begin
  Label6.Caption:='nieznany';
  ColorProgressBar1.ColorBegin:=clSilver;
  ColorProgressBar1.ColorEnd:=clGray;
  end
  else
  begin
  Label6.Caption:=IntToStr(stan.BatteryLifePercent)+'%';
  ColorProgressBar1.Position:=stan.BatteryLifePercent;

  if ColorProgressBar1.Position>=poziomWysoki then
    begin
    ColorProgressBar1.ColorBegin:=clLime;
    ColorProgressBar1.ColorEnd:=clGreen;
    end;
  if (ColorProgressBar1.Position>=poziomNiski) and (ColorProgressBar1.Position<poziomWysoki) then
    begin
    ColorProgressBar1.ColorBegin:=clYellow;
    ColorProgressBar1.ColorEnd:=clOlive;
    end;
  if ColorProgressBar1.Position<poziomNiski then
    begin
    ColorProgressBar1.ColorBegin:=clRed;
    ColorProgressBar1.ColorEnd:=clMaroon;
    end;
  end;

//data
Label8.Caption:=DateTimeToStr(Now);
end;

procedure TForm1.ApplicationEvents1Message(var Msg: tagMSG;
  var Handled: Boolean);
begin
if Msg.message=WM_POWERBROADCAST then FormCreate(Self);
end;

end.
